let argv = require('minimist')(process.argv.slice(2));

class FIPLAB{
  constructor(){
    this.arguments = {};
    
    //Override the console.log,warn,error,etc methods
    this._overrideConsole();

    //Set the module information properties
    this.uid = argv.uid;
    this.dbPath = argv.dbPath;

    //Parse the arguments
    if(typeof(argv.arguments) === 'string'){
      try{
        this.arguments = require(argv.arguments);
      } catch(e){
        console.error('Could not parse arguments', e.toString());
      }
    }

    this._setupDB();
  }

  _setupDB(){
    if(!this.dbPath){
      return;
    }

    const low = require('lowdb')
    const FileSync = require('lowdb/adapters/FileSync')
    const adapter = new FileSync(this.dbPath)
    
    this.db = low(adapter);
  }

  notify(options){
    let id = this.uid;
    let defaults = {
      "message": "",
      "id": ''
    };

    options = Object.assign(defaults, options);
    options.id = id + '_' + options.id;

    this.log('notification', [options]);
  }

  exit(result, success, options){
    if(!result){
      result = '';
    }

    if(typeof(success) !== 'boolean'){
      success = false;
    }

    let code = success ? 0 : 1;
    this._logFinished(result, success, options);
    process.exit(code);
  }

  _logFinished(result, success, options){
    let obj = {
      'result': result,
      'success': success
    };

    if(typeof(options) === 'object'){
      obj.options = options;
    }

    let out = success ? process.stdout : process.stderr;

    this.log('finished', obj, out);
  }

  log(type, options, writer){
    //Defaults
    if(typeof(options) !== 'object'){
      options = {};
    }

    if(typeof(writer) != 'function'){
      writer = process.stdout;
    }

    let logObj = {
      'type': type,
      'options': options
    };

    let json = JSON.stringify(logObj);
    json += '\n';

    writer.write(json);
  }

  /* Private Methods */
  _overrideConsole(){
    let fiplab = this;

    let methodsToOverride = ['log', 'warn', 'error', 'info'];

    //Loop through and override each of the given methods
    methodsToOverride.forEach(function(method) {
      console[method] = function() {
        let args = [];

        //Generate an array from the given arguments
        //Since they're actually an object {0: .., 1: ..}
        for(let key in arguments){
          let obj = arguments[key];
          args.push(obj);
        }

        //Call our log method
        fiplab.log(method, args);
      };
    });
  }
}

module.exports = new FIPLAB();